/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.movement;

import net.minecraft.command.CommandException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.constants.AiMutex;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class EntityAIReturn
extends EntityAIBase {
    public static int MaxTotalTicks = 100;
    private double endPosX;
    private double endPosY;
    private double endPosZ;
    private final EntityNPCInterface npc;
    private double[] preAttackPos;
    private int stuckCount = 0;
    private int stuckTicks = 0;
    private int totalTicks = 0;
    private boolean wasAttacked = false;

    public EntityAIReturn(EntityNPCInterface npc) {
        this.npc = npc;
        this.func_75248_a(AiMutex.PASSIVE);
    }

    private boolean isTooFar() {
        if (this.npc.homeDimensionId != this.npc.field_70170_p.field_73011_w.getDimension()) {
            return true;
        }
        int allowedDistance = this.npc.stats.aggroRange * 2;
        if (this.npc.ais.getMovingType() == 1) {
            allowedDistance += this.npc.ais.walkingRange;
        }
        return Util.instance.distanceTo(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, this.endPosX, this.endPosY, this.endPosZ) > (double)allowedDistance;
    }

    private void navigate(boolean towards) {
        if (!this.wasAttacked) {
            this.endPosX = this.npc.getStartXPos();
            this.endPosY = this.npc.getStartYPos();
            this.endPosZ = this.npc.getStartZPos();
        } else {
            this.endPosX = this.preAttackPos[0];
            this.endPosY = this.preAttackPos[1];
            this.endPosZ = this.preAttackPos[2];
        }
        double posX = this.endPosX;
        double posY = this.endPosY;
        double posZ = this.endPosZ;
        double range = this.npc.func_70011_f(posX, posY, posZ);
        if (range > (double)CustomNpcs.NpcNavRange || towards) {
            int distance = (int)range;
            distance = distance > CustomNpcs.NpcNavRange ? CustomNpcs.NpcNavRange / 2 : (distance /= 2);
            if (distance > 2) {
                Vec3d start = new Vec3d(posX, posY, posZ);
                Vec3d pos = RandomPositionGenerator.func_75464_a((EntityCreature)this.npc, (int)distance, (int)Math.min(distance / 2, 7), (Vec3d)start);
                if (pos != null) {
                    posX = pos.field_72450_a;
                    posY = pos.field_72448_b;
                    posZ = pos.field_72449_c;
                }
            }
        }
        this.tryBackHome(posX, posY, posZ);
    }

    private void tryBackHome(double endPosX, double endPosY, double endPosZ) {
        if (this.wasAttacked) {
            this.npc.func_70624_b(null);
        }
        this.npc.func_70661_as().func_75499_g();
        if (this.npc.homeDimensionId != this.npc.field_70170_p.field_73011_w.getDimension()) {
            try {
                Util.instance.teleportEntity(this.npc.field_70170_p.func_73046_m(), (Entity)this.npc, this.npc.homeDimensionId, this.npc.func_180486_cf());
            }
            catch (CommandException e) {
                LogWriter.error("Error teleport back home: ", e);
                this.npc.func_70661_as().func_75492_a(endPosX, endPosY, endPosZ, 1.3);
            }
        } else {
            this.npc.func_70661_as().func_75492_a(endPosX, endPosY, endPosZ, 1.3);
        }
    }

    public void func_75251_c() {
        this.wasAttacked = false;
        this.npc.func_70624_b(null);
    }

    public boolean func_75253_b() {
        boolean bo = true;
        if (this.npc.ais.onAttack == 2) {
            double dist = Util.instance.distanceTo(this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v, this.npc.getStartXPos(), this.npc.getStartYPos(), this.npc.getStartZPos());
            bo = dist > (double)this.npc.stats.aggroRange;
        }
        return this.npc.func_110143_aJ() > 0.0f && !this.npc.isFollower() && !this.npc.isKilled() && !this.npc.isAttacking() && !this.npc.advanced.jobInterface.isWorking() && !this.npc.isVeryNearAssignedPlace() && !this.npc.isInteracting() && !this.npc.func_184218_aH() && (!this.npc.func_70661_as().func_75500_f() || !this.wasAttacked || this.isTooFar()) && this.totalTicks <= MaxTotalTicks && bo;
    }

    public boolean func_75250_a() {
        CustomNpcs.debugData.start((Object)this.npc);
        if (this.npc.hasOwner() || this.npc.func_184218_aH() || !this.npc.ais.shouldReturnHome() || this.npc.isKilled() || !this.npc.func_70661_as().func_75500_f() || this.npc.isMoving() || this.npc.isInteracting()) {
            CustomNpcs.debugData.end((Object)this.npc);
            return false;
        }
        if (this.npc.aiOwnerNPC != null && !this.npc.func_70661_as().func_75500_f()) {
            this.totalTicks = 0;
            CustomNpcs.debugData.end((Object)this.npc);
            return false;
        }
        if (this.npc.ais.onAttack == 1 && (this.npc.func_70027_ad() || this.npc.func_70638_az() != null)) {
            this.totalTicks = 0;
            CustomNpcs.debugData.end((Object)this.npc);
            return false;
        }
        if (this.npc.ais.findShelter == 0 && (!this.npc.field_70170_p.func_72935_r() || this.npc.field_70170_p.func_72896_J()) && this.npc.field_70170_p.field_73011_w.func_191066_m()) {
            if (this.npc.field_70170_p.func_175699_k(this.npc.func_180425_c()) < 10) {
                CustomNpcs.debugData.end((Object)this.npc);
                return true;
            }
        } else if (this.npc.ais.findShelter == 1 && this.npc.field_70170_p.func_72935_r() && this.npc.field_70170_p.func_175678_i(this.npc.func_180425_c())) {
            CustomNpcs.debugData.end((Object)this.npc);
            return true;
        }
        if (this.npc.isAttacking()) {
            if (!this.wasAttacked) {
                this.wasAttacked = true;
                this.preAttackPos = new double[]{this.npc.field_70165_t, this.npc.field_70163_u, this.npc.field_70161_v};
            }
            CustomNpcs.debugData.end((Object)this.npc);
            return this.isTooFar();
        }
        if (!this.npc.isAttacking() && this.wasAttacked) {
            CustomNpcs.debugData.end((Object)this.npc);
            return true;
        }
        if (this.npc.homeDimensionId != this.npc.field_70170_p.field_73011_w.getDimension()) {
            CustomNpcs.debugData.end((Object)this.npc);
            return true;
        }
        switch (this.npc.ais.getMovingType()) {
            case 1: {
                CustomNpcs.debugData.end((Object)this.npc);
                return !this.npc.isInRange(this.npc.getStartXPos(), -1.0, this.npc.getStartZPos(), this.npc.ais.walkingRange);
            }
            case 2: {
                if (!(this.npc.ais.getDistanceSqToPathPoint() < (double)(CustomNpcs.NpcNavRange * CustomNpcs.NpcNavRange))) break;
                CustomNpcs.debugData.end((Object)this.npc);
                return false;
            }
        }
        CustomNpcs.debugData.end((Object)this.npc);
        return !this.npc.isVeryNearAssignedPlace();
    }

    public void func_75249_e() {
        this.stuckTicks = 0;
        this.totalTicks = 0;
        this.stuckCount = 0;
        this.navigate(false);
    }

    public void func_75246_d() {
        CustomNpcs.debugData.start((Object)this.npc);
        ++this.totalTicks;
        if (this.totalTicks > MaxTotalTicks) {
            this.tryBackHome(this.endPosX, this.endPosY, this.endPosZ);
            CustomNpcs.debugData.end((Object)this.npc);
            return;
        }
        if (this.stuckTicks > 0) {
            --this.stuckTicks;
        } else if (this.npc.func_70661_as().func_75500_f()) {
            ++this.stuckCount;
            this.stuckTicks = 10;
            if (this.totalTicks > 30 && this.wasAttacked && this.isTooFar() || this.stuckCount > 5) {
                this.tryBackHome(this.endPosX, this.endPosY, this.endPosZ);
            } else {
                this.navigate(this.stuckCount % 2 == 1);
            }
        } else {
            this.stuckCount = 0;
        }
        CustomNpcs.debugData.end((Object)this.npc);
    }

    public BlockPos getEndPositions() {
        if (!this.wasAttacked) {
            return new BlockPos((double)this.npc.getStartXPos(), this.npc.getStartYPos(), (double)this.npc.getStartZPos());
        }
        return new BlockPos(this.preAttackPos[0], this.preAttackPos[1], this.preAttackPos[2]);
    }
}

